<?php

namespace App\Http\Controllers\admin;

use App\Http\Controllers\Controller;
use App\Models\category;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Session;
use Illuminate\Support\Str;

class CategoryController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index()
    {
        $category = category::whereNull('parent_id')->get();
        return view('admin.views.product.category', compact('category'));
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request)
    {
        $category = new category();
        $category->name = $request->input('name');
//        $category->slug =Str::slug($request->input('slug'));
        if (empty($request->input('slug'))) {
            $category->slug = $this->make_slug($request->input('name'));
        } else {
            $category->slug = $this->make_slug($request->input('slug'));
        }
        if (!empty($request->parent_id)) {
            $category->parent_id = $request->parent_id;
        }
        $category->save();
        Session::flash('success', 'دسته بندی  جدید با موفقیت درج شد');
        return redirect('/category');
    }

    /**
     * Display the specified resource.
     */
    public function show(string $id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(string $id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, string $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(string $id)
    {
        //
    }

    public function make_slug($string, $separator = '-')
    {
        $string = trim($string);
        $string = mb_strtolower($string, 'UTF-8');
        $string = str_replace(['؟', '?'], '', $string);
        return preg_replace('/\s+/u', '-', trim($string));

        return $string;
    }

    public function categoryLoad($slug)
    {
        $category = category::where('slug', $slug)->first();
        return $category;
    }

    public static function showHeaderMenu($id)
    {
        $subCategory = category::where('parent_id', $id)->get();
        foreach ($subCategory as $value) {
            echo '<li class="list-item">
                                            <a class="nav-link" href="'.route('categoryLoad',$value->slug).'">' . $value->name . '</a>
                                        </li>';
        }

    }


}
